/*
 * MovementInfo.h
 *
 * Created 8/23/2009 By Johnny Huynh
 *
 * Version 00.00.01 8/23/2009
 *
 * Copyright Information:
 * All content copyright  2009 Johnny Huynh. All rights reserved.
 */
 
 #ifndef MOVEMENT_INFO_H
 #define MOVEMENT_INFO_H
 
 template <typename T> class MovementInfo;
 
 #include "global.h"
 
 #include "referenceCount.h"
 
 #include "MoveInfo.h"
 
 /**
  * Class specification for MovementInfo
  */
 template <typename T>
 class MovementInfo : public ReferenceCount
 {
 // Data Members
 private:
    double _duration; // the time length the movement distance is spread over
    
 // Local Functions
 public:
    MovementInfo( const double duration = 0.0 );
    MovementInfo( const MovementInfo<T>& movement_info );
    virtual ~MovementInfo();
    inline MovementInfo<T>& operator=( const MovementInfo<T>& movement_info );
    inline double get_duration() const;
    inline void set_duration( const double duration );
    virtual inline double process_movement( Object<T>* obj_Ptr, MoveInfo<T>* move_info_Ptr, double current_time ) = 0;
 
 // Private Functions
 private:
    
 // Friend Functions
 public:
    
 };
 
 /** LOCAL FUNCTIONS **/
 
 /**
  * Constructor
  */
 template <typename T>
 MovementInfo<T>::MovementInfo( const double duration )
                 : _duration( duration )
 {
    
 }
 
 /**
  * Copy Constructor
  */
 template <typename T>
 MovementInfo<T>::MovementInfo( const MovementInfo<T>& movement_info )
                 : _duration( movement_info._duration )
 {
    
 }
 
 /**
  * Destructor
  */
 template <typename T>
 MovementInfo<T>::~MovementInfo()
 {
    
 }
 
 /**
  * operator=() copies the content of the specified MovementInfo to this MovementInfo.
  *
  * @param (const MovementInfo<T>&) movement_info
  * @return MovementInfo<T>&
  */
 template <typename T>
 inline MovementInfo<T>& MovementInfo<T>::operator=( const MovementInfo<T>& movement_info )
 {
    _duration = movement_info._duration;
    
    return *this;
 }
 
 /**
  * get_duration() returns the movement duration.
  *
  * @return double
  */
 template <typename T>
 inline double MovementInfo<T>::get_duration() const
 {
    return _duration;
 }
 
 /**
  * set_duration() sets the movement duration to the specified duration.
  *
  * @param (const double) duration
  */
 template <typename T>
 inline void MovementInfo<T>::set_duration( const double duration )
 {
    _duration = duration;
 }
 
 /** FRIEND FUNCTIONS **/
 
 #endif // MOVEMENT_INFO_H